/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common;

import com.aptana.core.build.IProblem;
import com.aptana.core.resources.FileStoreUniformResource;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.resources.IUniformResourceChangeEvent;
import com.aptana.core.resources.IUniformResourceChangeListener;
import com.aptana.core.resources.IUniformResourceMarker;
import com.aptana.core.resources.MarkerUtils;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.ICommonAnnotationModel;
import com.aptana.editor.common.ProblemAnnotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalFileAnnotationModel
extends AbstractMarkerAnnotationModel
implements ICommonAnnotationModel {
    private List<ProblemAnnotation> fGeneratedAnnotations;
    private IUniformResource resource;
    private IUniformResourceChangeListener resourceChangeListener;

    public ExternalFileAnnotationModel(IFileStore fileStore) {
        this.resource = new FileStoreUniformResource(fileStore);
        this.resourceChangeListener = new ResourceChangeListener();
        this.fGeneratedAnnotations = new ArrayList<ProblemAnnotation>();
    }

    protected IMarker[] retrieveMarkers() {
        return MarkerUtils.findMarkers((IUniformResource)this.resource, (String)"org.eclipse.core.resources.marker", (boolean)true);
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null, 1, null);
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            MarkerUtils.addResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        } else {
            MarkerUtils.removeResourceChangeListener((IUniformResourceChangeListener)this.resourceChangeListener);
        }
    }

    protected boolean isAcceptable(IMarker marker) {
        return marker instanceof IUniformResourceMarker && this.resource.equals(((IUniformResourceMarker)marker).getUniformResource());
    }

    protected void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas;
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                    break;
                }
            }
            ++n2;
        }
        this.fireModelChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportProblems(Map<String, Collection<IProblem>> map, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        boolean temporaryProblemsChanged = false;
        try {
            Object[] markers = this.retrieveMarkers();
            if (!ArrayUtil.isEmpty((Object[])markers)) {
                Object[] objectArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    Object marker = objectArray[n2];
                    if (map.containsKey(marker.getType())) {
                        this.removeMarkerAnnotation((IMarker)marker);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        Object object = this.getLockObject();
        synchronized (object) {
            if (!CollectionsUtil.isEmpty(this.fGeneratedAnnotations)) {
                temporaryProblemsChanged = true;
                this.removeAnnotations(this.fGeneratedAnnotations, false, true);
                this.fGeneratedAnnotations.clear();
            }
            if (!CollectionsUtil.isEmpty(map)) {
                block8: for (Collection<IProblem> problems : map.values()) {
                    if (CollectionsUtil.isEmpty(problems)) continue;
                    for (IProblem problem : problems) {
                        if (monitor != null && monitor.isCanceled()) continue block8;
                        Position position = this.generatePosition(problem);
                        if (position == null) continue;
                        try {
                            ProblemAnnotation annotation = new ProblemAnnotation(null, problem);
                            this.addAnnotation(annotation, position, false);
                            this.fGeneratedAnnotations.add(annotation);
                            temporaryProblemsChanged = true;
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        if (temporaryProblemsChanged) {
            this.fireModelChanged();
        }
    }

    private Position generatePosition(IProblem problem) {
        int start = problem.getOffset();
        if (start < 0) {
            return new Position(0);
        }
        int length = problem.getLength();
        if (length < 0) {
            return null;
        }
        return new Position(start, length);
    }

    private class ResourceChangeListener
    implements IUniformResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IUniformResourceChangeEvent event) {
            if (ExternalFileAnnotationModel.this.resource.equals(event.getResource())) {
                ExternalFileAnnotationModel.this.update(event.getMarkerDeltas());
            }
        }
    }
}

